/*------------------------------------------------------------------------------*
 * File Name: ImpWizDataSelection.c												*
 * Creation: 																	*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES							*
 * Sim 04-12-2007 REORGANIZE_PARTIAL_RANGE_IMPORT								*
 * Sim 05-28-2007 SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES						*
 * Hong 07/13/07 QA80-10040 TEMP_GET_BACK_ITEM_FOCUS_AS_UPDATEPREVIEW_EAT_THE_FOCUS
 *	Hong 08/27/08 QA80-9206 v8.0833 FIX_FAIL_GET_ACTUAL_NUM_COLIMN_AS_PARTIAL_COUNTED
 *	Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include "IWfirst.h"



///Danice 12/25/03 v7.5788 NOTUSE_SHOW
DWORD ImpWizDataSelectionPage::OnShowStatus(DWORD InternalStatus)
{
	return (IS_SHOW_PARTIAL_IMPORT_PAGE ? PSS_Show : PSS_Ignore);
}
///END NOTUSE_SHOW

//--------------------------------------------------------------------------
// UpdateWksCtrl
//
// Call this function to update the worksheet control on the specified page.
//--------------------------------------------------------------------------
void ImpWizDataSelectionPage::UpdateWksCtrl(int iWizPageID)
{
	///Danice 12/26/03 v7.5789 UPDATE_DIRECTLY
/*	int iCtrlID;
	switch( iWizPageID )
	{
	case IDD_AIW_COLUMNS:
		iCtrlID = IDC_COL_WKS_PREVIEW;
		break;
	case IDD_IW_RANGE:
		iCtrlID = IDC_RANGE_PREVIEW;
		break;
	case IDD_BIW_DATAPATERN:
		iCtrlID = IDC_BIW_DATAPATERN_PREVIEW_LC;
		break;
	default:
		return;
	}*/
	///END UPDATE_DIRECTLY

	//WorksheetControl wc = ImportWizDlg.GetItem(iCtrlID, iWizPageID);
	//WorksheetControl wc = GetItem(IDC_RANGE_PREVIEW);
	m_wc.Attach(m_pSheet->GetWksName());
	m_wc.Update();
}

void ImpWizDataSelectionPage::UpdatePreview(int iWizPageID)
{
	///Danice 12/25/03 v7.5788 SAVE_BEFORE_CHANGE	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//m_pSheet->SetASCIMP(m_pAscimp);
	//m_pSheet->SetBINIMP(m_pBinimp);

	//m_pSheet->UpdateImpStructCommonFromTree();//Hong 8/31/06 COMMON_REMOVE_FROM_STRUCTURE
	/// Hong 9/05/06 REMOVE_FILE_IMPORT
	int nType = fuGetType(s_trFilter);
	if(nType == FILTER_TYPE_ASCII)
	{
		ASCIMP ascimp;
		fuGetASCIMP(s_trFilter, ascimp);
		*m_pAscimp = ascimp;
	}
	else
	{
		BINIMP binimp;
		fuGetBINIMP(s_trFilter, binimp);
		*m_pBinimp = binimp;
	}
	/// end REMOVE_FILE_IMPORT
	m_pSheet->ImportToWks();
	
	//m_pSheet->GetASCIMP(m_pAscimp);
	//m_pSheet->GetBINIMP(m_pBinimp);
	///END SAVE_BEFORE_CHANGE	NEW_ACCESS_METHOD_GET_POINTER
			
	UpdateWksCtrl(iWizPageID);
}

BOOL ImpWizDataSelectionPage::OnInit_Range() ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	ON_PAGE_CHECK_PARTIAL_IMPORT
	
	///Danice PAGE_INIT_ONCE
	if(!ImpWizardPage::Init())
		return FALSE;
	///END PAGE_INIT_ONCE

	
	///Danice 2/24/04 v8.0825 PREVENT_INIT_RUN_IN_ASC_AND_BIN
	if(bHasInit)
	{
		Range_UpdateData(FALSE); // FALSE=update dialog
		///---Sim 08-31-2006 GET_FILTER_BY_ID
		//Range_EnablePartialCtrls(s_trFilter.Common.Partial.nVal);
		Range_EnablePartialCtrls(fuGetInt(s_trFilter, IDE_IMP_PARTIAL, 0));
		///---END GET_FILTER_BY_ID
		return true;
	}
	///END PREVENT_INIT_RUN_IN_ASC_AND_BIN
	
	m_bPartialChanged = FALSE; /// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
		
	///Jacky 12/14/03 v7.5781 DEFINE_SOME_NEW_MEMBER
	m_chkPartial     = GetItem(IDC_RANGE_PARTIAL);
	m_btnApply       = GetItem(IDC_APPLY_PARTIAL);
    m_editFirstCol   = GetItem(IDC_RANGE_FIRSTCOL);
	m_editFirstRow   = GetItem(IDC_RANGE_FIRSTROW);
	m_ebSkipDataRows = GetItem(IDC_IW_SKIP_ROWS);
	m_ebReadRows     = GetItem(IDC_IW_READ_ROWS);
	m_editLastRow    = GetItem(IDC_RANGE_LASTROW);
	m_editLastCol    = GetItem(IDC_RANGE_LASTCOL);
	
	/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES, move to Source page
    ///m_cbImportMode   = GetItem(IDC_RANGE_MODE);
    /// end NEW_IMPORT_MODES
    
    m_cbNonNumeric   = GetItem(IDC_IW_HEADER_NONNUMERIC);
    //m_wc             = GetItem(IDC_RANGE_PREVIEW);
    
	/// EJP 01-07-2005 v8.0182 QA70-6555 NEW_IMPORT_MODES
	SetComboBoxItems(m_cbNonNumeric, _L("Terminate import|Read as text|Start new worksheet|Start new column"), '|');
	/// end NEW_IMPORT_MODES
	
    if( !m_wc ) /// EJP 02-26-2004 v7.5828 ONLY_CREATE_WKS_CTRL_ONCE
    {
		Control ctrlTmp =		GetItem(IDC_RANGE_PREVIEW);
		HWND hWnd = ctrlTmp.GetSafeHwnd();
		if(hWnd)
			m_wc.CreateControl(hWnd);
		else
			ASSERT(FALSE);
		m_ctrlNonNumericLabel = GetItem(IDC_NONNUMERIC_LABEL);
    }    
	///End DEFINE_SOME_NEW_MEMBER
	
	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//m_pSheet->GetASCIMP(m_pAscimp);
	//m_pSheet->GetBINIMP(m_pBinimp); ///Jacky 12/21/03 v7.5784 CALL_SHEET_FUNCTION       
	m_pAscimp = m_pSheet->GetASCIMP_Pointer();
	m_pBinimp = m_pSheet->GetBINIMP_Pointer();
	///END NEW_ACCESS_METHOD_GET_POINTER
	
	Range_UpdateData(FALSE); // FALSE=update dialog
	/// Hong 8/31/06 GET_FILTER_BY_ID
	//Range_EnablePartialCtrls(s_trFilter.Common.Partial.nVal);
	int nVal = fuGetInt(s_trFilter, IDE_IMP_PARTIAL, 0);
	Range_EnablePartialCtrls(nVal);
	/// end GET_FILTER_BY_ID
	///Danice 12/23/03 v7.5786 SAVE_CHANGE	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//m_pSheet->SetASCIMP(m_pAscimp);
	//m_pSheet->SetBINIMP(m_pBinimp); ///Jacky 12/21/03 v7.5784 CALL_SHEET_FUNCTION       
	///END SAVE_CHANGE

	bHasInit = true;	///Danice 2/24/04 v8.0825 PREVENT_INIT_RUN_IN_ASC_AND_BIN
	return TRUE;
}

BOOL ImpWizDataSelectionPage::OnActive_Range() ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	/// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
	//WorksheetControl wc = ImportWizDlg.GetItem(IDC_RANGE_PREVIEW, IDD_IW_RANGE); ///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//m_pSheet->GetASCIMP(m_pAscimp);	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//m_pSheet->GetBINIMP(m_pBinimp); ///Jacky 12/21/03 v7.5784 CALL_SHEET_FUNCTION       

	
	//wc.SetFont(IW_PREVIEW_FONT);
	m_wc.SetFont(IW_PREVIEW_FONT);
	/// end ALLOW_CHANGING_PREVIEW_FONT
	
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	m_bPartialChanged = FALSE;
	m_btnApply.Enable = m_bPartialChanged;
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT

	UpdatePreview(IDD_IW_RANGE);
	return TRUE;
}

bool ImpWizDataSelectionPage::OnKillActive_Range()
{
	//m_pSheet->SetASCIMP(m_pAscimp);	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//m_pSheet->SetBINIMP(m_pBinimp); ///Jacky 12/21/03 v7.5784 CALL_SHEET_FUNCTION       
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	if ( m_btnApply && m_btnApply.Enable )
	{
		Range_UpdateData();
		m_bPartialChanged = FALSE;
	}
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
		
	return true;
}


BOOL ImpWizDataSelectionPage::OnSelChangeNonNumeric(Control ctrl)
{
	ComboBox cbNonNumeric(ctrl);
	int iNonNumeric = cbNonNumeric.GetCurSel();

	/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES
	///bool bEnable = true;
	/// end NEW_IMPORT_MODES
	switch( iNonNumeric )
	{
	case NONNUMERIC_WIZ_TERMINATE:
		m_pAscimp->iNonnumeric = NONNUMERIC_TERMINATE;
		break;
	case NONNUMERIC_WIZ_READ_AS_TEXT:
		m_pAscimp->iNonnumeric = NONNUMERIC_READ_AS_MISSING;
		break;
	case NONNUMERIC_WIZ_NEW_WKS:
		m_pAscimp->iNonnumeric = NONNUMERIC_START_NEW_WKSCOL;
		/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES
		///fuSetImportMode(s_trFilter, ASCIMP_MODE_REPLACE_DATA);
		///bEnable = false;
		/// end NEW_IMPORT_MODES
		break;
	case NONNUMERIC_WIZ_NEW_COL:
		//m_pAscimp->iNonnumeric = NONNUMERIC_START_NEW_WKSCOL;
		m_pAscimp->iNonnumeric = NONNUMERIC_APPEND_TO_LABEL;//Hong 8/09/06 FIX_MISS_NEW_COL
		/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES
		///fuSetImportMode(s_trFilter, ASCIMP_MODE_APPEND_COLS);
		///bEnable = false;
		/// end NEW_IMPORT_MODES
		break;
	}

	/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES, move to Source page
	/*
	//ComboBox cbImportMode = ImportWizDlg.GetItem(IDC_RANGE_MODE, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//cbImportMode.SetCurSel(fuGetImportMode(s_trFilter));
	m_cbImportMode.SetCurSel(fuGetImportMode(s_trFilter));
	//cbImportMode.Enable = bEnable;
	m_cbImportMode.Enable = bEnable;
	*/
	/// end NEW_IMPORT_MODES
	/// Hong 9/18/06 NEED_UPDATE_FILTER
	fuSetASCIMP(s_trFilter, *m_pAscimp);
	/// end NEED_UPDATE_FILTER
	UpdatePreview(IDD_IW_RANGE);
	/// Hong 07/13/07 QA80-10040 TEMP_GET_BACK_ITEM_FOCUS_AS_UPDATEPREVIEW_EAT_THE_FOCUS
	// In UpdatePreview the focus was changed, need get it back. This is temp fix, later need to change UpdatePreview NOT change focus
	SetFocus(GetSafeHwnd());
	SetFocus(ctrl.GetSafeHwnd());
	/// END TEMP_GET_BACK_ITEM_FOCUS_AS_UPDATEPREVIEW_EAT_THE_FOCUS
	return TRUE;
}

BOOL ImpWizDataSelectionPage::OnSelChangeMode_Range(Control ctrl)///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	ComboBox cbMode(ctrl);
	fuSetImportMode(s_trFilter, cbMode.GetCurSel());
	UpdatePreview(IDD_IW_RANGE);
	return TRUE;
}

BOOL ImpWizDataSelectionPage::OnClickPartial_Range(Control ctrl)///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	Range_UpdateData();
	/// Hong 8/31/06 GET_FILTER_BY_ID
	//Range_EnablePartialCtrls(s_trFilter.Common.Partial.nVal);
	int nVal = fuGetInt(s_trFilter, IDE_IMP_PARTIAL, 0);
	Range_EnablePartialCtrls(nVal);
	/// end GET_FILTER_BY_ID
	UpdatePreview(IDD_IW_RANGE);
	return TRUE;
}

/// EJP 07-21-2003 v7.0630 QA70-4073 ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW
BOOL ImpWizDataSelectionPage::OnClickApplyPartial_Range(Control ctrl)///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	Range_UpdateData();
	/// EJP 11-26-2003 v7.5773 CHECK_PARTIAL_IMPORT_FROM_SETTINGS
	Range_UpdateData(false); // update user's settings
	/// end CHECK_PARTIAL_IMPORT_FROM_SETTINGS
	UpdatePreview(IDD_IW_RANGE);
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	if ( m_btnApply )
		m_btnApply.Enable = FALSE;
	m_bPartialChanged = FALSE;
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	return TRUE;
}
/// end ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW

BOOL ImpWizDataSelectionPage::OnEditChangeSkipDataRows(Control ctrl)
{
	Edit ebSkipDataRows(ctrl);
	int iSkipRows = atoi(ebSkipDataRows.Text);
	if( iSkipRows < 0 )
		iSkipRows = 0;
	
	/// EJP 08-27-2003 v7.5677 QA70-5073 ADD_READROWS
	//Edit ebReadRows = ImportWizDlg.GetItem(IDC_IW_READ_ROWS, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//ebReadRows.Enable = (iSkipRows > 0);
	m_ebReadRows.Enable = (iSkipRows > 0);
	/// end ADD_READROWS

	///---Sim 04-12-2007 REORGANIZE_PARTIAL_RANGE_IMPORT remove
	/*
	/// EJP 07-23-2003 v7.0631 QA70-4575 ADD_SKIPROWS_TO_BINIMP
	///s_ascimp.iSkipRows = iSkipRows;
	//s_trFilter.Common.SkipRows.nVal = iSkipRows;
	fuSetInt(s_trFilter, IDE_IMP_SKIPROWS, iSkipRows);// Hong 8/31/06 GET_FILTER_BY_ID
	/// end ADD_SKIPROWS_TO_BINIMP

	UpdatePreview(IDD_IW_RANGE); 
	*/
	///---END REORGANIZE_PARTIAL_RANGE_IMPORT remove
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	if ( m_btnApply )
		m_btnApply.Enable= TRUE;
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	return TRUE;
}

/// EJP 08-27-2003 v7.5677 QA70-5073 ADD_READROWS
BOOL ImpWizDataSelectionPage::OnEditChangeReadRows(Control ctrl)
{
	///---Sim 04-12-2007 REORGANIZE_PARTIAL_RANGE_IMPORT remove
	/*
	Edit ebReadRows(ctrl);
	int iReadRows = atoi(ebReadRows.Text);
	if( iReadRows < 1 )
		iReadRows = 1;
	//s_trFilter.Common.ReadRows.nVal = iReadRows;
	fuSetInt(s_trFilter, IDE_IMP_READROWS, iReadRows);// Hong 8/31/06 GET_FILTER_BY_ID
	UpdatePreview(IDD_IW_RANGE);
	*/
	///---END REORGANIZE_PARTIAL_RANGE_IMPORT remove
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	if ( m_btnApply )
		m_btnApply.Enable= TRUE;
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	return TRUE;
}
/// end ADD_READROWS

/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
BOOL ImpWizDataSelectionPage::OnEditChangePartial(Control ctrl)
{
	if ( m_btnApply )
		m_btnApply.Enable= TRUE;
	return TRUE;
}
/// end /// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT

void ImpWizDataSelectionPage::Range_EnablePartialCtrls(BOOL bEnable) //=true)
{
	//Edit editFirstCol = ImportWizDlg.GetItem(IDC_RANGE_FIRSTCOL, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//if( editFirstCol )
	  if( m_editFirstCol )
	//	editFirstCol.Enable = bEnable;
	    m_editFirstCol.Enable = bEnable;
		
	//Edit editLastCol = ImportWizDlg.GetItem(IDC_RANGE_LASTCOL, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	//if( editLastCol )
	  if( m_editLastCol )
	//	editLastCol.Enable = bEnable;
	    m_editLastCol.Enable = bEnable;
		
	//Edit editFirstRow = ImportWizDlg.GetItem(IDC_RANGE_FIRSTROW, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	//if( editFirstRow )
	  if( m_editFirstRow )
	//	editFirstRow.Enable = bEnable;
	    m_editFirstRow.Enable = bEnable;
	
	//Edit editLastRow = ImportWizDlg.GetItem(IDC_RANGE_LASTROW, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	//if( editLastRow )
	  if( m_editLastRow )
	//	editLastRow.Enable = bEnable;
	    m_editLastRow.Enable = bEnable;

	///---Sim 04-12-2007 REORGANIZE_PARTIAL_RANGE_IMPORT
	int iSkipRows = 0;
	if ( m_ebSkipDataRows )
	{
		m_ebSkipDataRows.Enable = bEnable;
		
		iSkipRows = atoi(m_ebSkipDataRows.Text);
		if( iSkipRows < 0 )
			iSkipRows = 0;
	}
	
	if ( m_ebReadRows )
	{
		m_ebReadRows.Enable = bEnable && (iSkipRows > 0);
	}
	///---END REORGANIZE_PARTIAL_RANGE_IMPORT
	
	/// EJP 07-21-2003 v7.0630 QA70-4073 ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW
	//Button btnApply = ImportWizDlg.GetItem(IDC_APPLY_PARTIAL, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//if( btnApply )
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	/*
	  if( m_btnApply )
	//	btnApply.Enable = bEnable;
	    m_btnApply.Enable = bEnable;
	*/
	if ( m_btnApply )
	{
		if ( !bEnable )
			m_btnApply.Enable = false;
		else
			m_btnApply.Enable = m_bPartialChanged;
	}
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	/// end ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW
}

void ImpWizDataSelectionPage::DataSel_UpdateNonNumericCtrls()
{
	/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES
	///bool bImportModeEnable = true, bNonNumericVisible = IS_FILTER_TYPE_ASCII;
	bool bNonNumericVisible = IS_FILTER_TYPE_ASCII;
	/// end QA70-6555 NEW_IMPORT_MODES

	//Control ctrlNonNumericLabel = ImportWizDlg.GetItem(IDC_NONNUMERIC_LABEL, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//ctrlNonNumericLabel.Visible = bNonNumericVisible;
	m_ctrlNonNumericLabel.Visible = bNonNumericVisible;

	//ComboBox cbNonNumeric = ImportWizDlg.GetItem(IDC_IW_HEADER_NONNUMERIC, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//cbNonNumeric.Visible = bNonNumericVisible;
	m_cbNonNumeric.Visible = bNonNumericVisible;

	//ComboBox cbImportMode = ImportWizDlg.GetItem(IDC_RANGE_MODE, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES, move to Source page
	/*
	if( bNonNumericVisible )
	{
		//int iNonNumeric = cbNonNumeric.GetCurSel();
		int iNonNumeric = m_cbNonNumeric.GetCurSel();
		if( NONNUMERIC_WIZ_NEW_WKS == iNonNumeric || NONNUMERIC_WIZ_NEW_COL == iNonNumeric )
			bImportModeEnable = false;
	}
	
	//cbImportMode.Enable = bImportModeEnable;
	m_cbImportMode.Enable = bImportModeEnable;
	*/
	/// end NEW_IMPORT_MODES
}

/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES
/*
void ImpWizDataSelectionPage::DataSel_ConvertStructToDialog(int &iNonNumeric, int &iImportMode)
{
	switch( iNonNumeric )
	{
	case NONNUMERIC_TERMINATE:
		iNonNumeric = NONNUMERIC_WIZ_TERMINATE;
		// import mode does not change
		break;
	case NONNUMERIC_READ_AS_MISSING:
	case NONNUMERIC_APPEND_TO_LABEL:
		iNonNumeric = NONNUMERIC_WIZ_READ_AS_TEXT;
		// import mode does not change
		break;
	case NONNUMERIC_START_NEW_WKSCOL:
		if( ASCIMP_MODE_REPLACE_DATA == iImportMode )
			iNonNumeric = NONNUMERIC_WIZ_NEW_WKS;
		else
		{
			iNonNumeric = NONNUMERIC_WIZ_NEW_COL;
			iImportMode = ASCIMP_MODE_APPEND_COLS;
		}
		break;
	}
}

void ImpWizDataSelectionPage::DataSel_ConvertDialogToStruct(int &iNonNumeric, int &iImportMode)
{
	switch( iNonNumeric )
	{
	case NONNUMERIC_WIZ_TERMINATE:
		iNonNumeric = NONNUMERIC_TERMINATE;
		// import mode does not change
		break;
	case NONNUMERIC_WIZ_READ_AS_TEXT:
		iNonNumeric = NONNUMERIC_READ_AS_MISSING;
		// import mode does not change
		break;
	case NONNUMERIC_WIZ_NEW_WKS:
	case NONNUMERIC_WIZ_NEW_COL:
		iNonNumeric = NONNUMERIC_START_NEW_WKSCOL;
		// import mode does not change
		break;
	}
}
*/
/// end NEW_IMPORT_MODES

void ImpWizDataSelectionPage::Range_UpdateData(BOOL bDlgToData) //=true)
{
	//Button chkPartial = ImportWizDlg.GetItem(IDC_RANGE_PARTIAL, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	//Edit editFirstCol = ImportWizDlg.GetItem(IDC_RANGE_FIRSTCOL, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	//Edit editLastCol = ImportWizDlg.GetItem(IDC_RANGE_LASTCOL, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	//Edit editFirstRow = ImportWizDlg.GetItem(IDC_RANGE_FIRSTROW, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	//Edit editLastRow = ImportWizDlg.GetItem(IDC_RANGE_LASTROW, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	//ComboBox cbImportMode = ImportWizDlg.GetItem(IDC_RANGE_MODE, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	//Edit ebSkipDataRows = ImportWizDlg.GetItem(IDC_IW_SKIP_ROWS, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	//ComboBox cbNonNumeric = ImportWizDlg.GetItem(IDC_IW_HEADER_NONNUMERIC, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL

	/// EJP 08-27-2003 v7.5677 QA70-5073 ADD_READROWS
	//Edit ebReadRows = ImportWizDlg.GetItem(IDC_IW_READ_ROWS, IDD_IW_RANGE);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	/// end ADD_READROWS
	
	if( bDlgToData )
	{
		//if( chkPartial.Check )
		if( m_chkPartial.Check )
		{
			int i;
			
			//s_trFilter.Common.Partial.nVal = 1;
			fuSetInt(s_trFilter, IDE_IMP_PARTIAL, 1);// Hong 8/31/06 GET_FILTER_BY_ID
			
			///---Sim 12-23-2006 FIX_BUG_WHEN_NUMBER_OF_COLUMN_IS_ZERO
			int nNumColumns = 0;
			nNumColumns = fuGetInt(s_trFilter, IDE_IMP_NUMCOLUMNS, 0);
			if ( 0 == nNumColumns )
			{
				if ( fuGetType(s_trFilter) == FILTER_TYPE_ASCII )
				{
					///---Sim 05-28-2007 SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES
					ASCIMP ascimp;
					fuGetASCIMP(s_trFilter, ascimp);
					string strDataFile = m_pSheet->GetFileName();
					//AscImpReadFileStruct(strDataFile, &ascimp);
					/// Hong 08/27/08 QA80-9206 v8.0833 FIX_FAIL_GET_ACTUAL_NUM_COLIMN_AS_PARTIAL_COUNTED
					ascimp.iPartial = 0;
					/// end FIX_FAIL_GET_ACTUAL_NUM_COLIMN_AS_PARTIAL_COUNTED
					AscImpReadFileStruct(strDataFile, &ascimp, AIRF_USE_ASCIMP);
					nNumColumns = ascimp.iNumColumns;
					///---END SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES
				}
			}
			///---END FIX_BUG_WHEN_NUMBER_OF_COLUMN_IS_ZERO

			/// EJP 11-26-2003 v7.5773 CHECK_PARTIAL_IMPORT_FROM_SETTINGS
			///s_trFilter.Common.PartialC1.nVal = atoi(editFirstCol.Text) - 1;
			
			//i = atoi(editFirstCol.Text) - 1;
			i = atoi(m_editFirstCol.Text) - 1;
			
			if( i < 0 )
				i = 0;
			///---Sim 12-23-2006 FIX_BUG_WHEN_NUMBER_OF_COLUMN_IS_ZERO
			///// EJP 01-15-2004 v7.5802 QA70-5211 CHECK_BINIMP_PARTIAL_COL_RANGE
			//// If binary import then safe to check max col index.
			//else if( fuGetType(s_trFilter) == FILTER_TYPE_BINARY && i >= m_pBinimp->iNumColumns )
				//i = m_pBinimp->iNumColumns - 1;
			///// end CHECK_BINIMP_PARTIAL_COL_RANGE
			else if ( i >= nNumColumns )
				i = nNumColumns - 1;
			///---END FIX_BUG_WHEN_NUMBER_OF_COLUMN_IS_ZERO
			//s_trFilter.Common.PartialC1.nVal = i;
			fuSetInt(s_trFilter, IDE_IMP_PARTIALC1, i);// Hong 8/31/06 GET_FILTER_BY_ID
			/// end CHECK_PARTIAL_IMPORT_FROM_SETTINGS

			///---Sim 12-23-2006 KEEP_SAME_AS_PARTIALC1
			//i = atoi(editLastCol.Text);
			//i = atoi(m_editLastCol.Text);
			i = atoi(m_editLastCol.Text) - 1;
			
			//if( i < 1 )
			if( i < 0 )
				i = -1; // last column
			///---END KEEP_SAME_AS_PARTIALC1
			///---Sim 12-23-2006 FIX_BUG_WHEN_NUMBER_OF_COLUMN_IS_ZERO
			///// EJP 01-15-2004 v7.5802 QA70-5211 CHECK_BINIMP_PARTIAL_COL_RANGE
			//// If binary import then safe to check max col index.
			//else if( fuGetType(s_trFilter) == FILTER_TYPE_BINARY && i >= m_pBinimp->iNumColumns )
				//i = m_pBinimp->iNumColumns - 1;
			///// end CHECK_BINIMP_PARTIAL_COL_RANGE
			///// Hong 9/21/06 ADD_CHECK_ASCII_PARTIAL_COL_RANGE	
			//else if( fuGetType(s_trFilter) == FILTER_TYPE_ASCII && i >= m_pAscimp->iNumColumns )
				//i = m_pAscimp->iNumColumns - 1;
			///// END ADD_CHECK_ASCII_PARTIAL_COL_RANGE
			else if ( i >= nNumColumns )
				i = nNumColumns - 1;
			///---END FIX_BUG_WHEN_NUMBER_OF_COLUMN_IS_ZERO
			else
			{
				//i--; ///---Sim 12-23-2006 KEEP_SAME_AS_PARTIALC1 remove
				/// Hong 8/31/06 GET_FILTER_BY_ID
				//if( i < s_trFilter.Common.PartialC1.nVal )
					//i = s_trFilter.Common.PartialC1.nVal;
				int nPartialC1 = fuGetInt(s_trFilter, IDE_IMP_PARTIALC1, 0);
				if(i < nPartialC1)
					i = nPartialC1;
				/// end GET_FILTER_BY_ID
			}
			//s_trFilter.Common.PartialC2.nVal = i;
			fuSetInt(s_trFilter, IDE_IMP_PARTIALC2, i);// Hong 8/31/06 GET_FILTER_BY_ID
			
			/// EJP 11-26-2003 v7.5773 CHECK_PARTIAL_IMPORT_FROM_SETTINGS
			///s_trFilter.Common.PartialR1.nVal = atoi(editFirstRow.Text) - 1;
			
			//i = atoi(editFirstRow.Text) - 1;
			i = atoi(m_editFirstRow.Text) - 1;
			
			if( i < 0 )
				i = 0;
			//s_trFilter.Common.PartialR1.nVal = i;
			fuSetInt(s_trFilter, IDE_IMP_PARTIALR1, i);// Hong 8/31/06 GET_FILTER_BY_ID
			/// end CHECK_PARTIAL_IMPORT_FROM_SETTINGS

			///---Sim 12-23-2006 KEEP_SAME_AS_PARTIALR1
			//i = atoi(editLastRow.Text);
			//i = atoi(m_editLastRow.Text);
			i = atoi(m_editLastRow.Text) - 1;
			
			//if( i < 1 )
			if( i < 0 )
				i = -1; // last column
			///---END KEEP_SAME_AS_PARTIALR1
			else
			{
				//i--; ///---Sim 12-23-2006 KEEP_SAME_AS_PARTIALR1
				/// Hong 8/31/06 GET_FILTER_BY_ID
				//if( i < s_trFilter.Common.PartialR1.nVal )
					//i = s_trFilter.Common.PartialR1.nVal;
				int nPartialR1 = fuGetInt(s_trFilter, IDE_IMP_PARTIALR1, 0);
				if(i < nPartialR1)
					i = nPartialR1;
				/// end GET_FILTER_BY_ID
			}
			//s_trFilter.Common.PartialR2.nVal = i;
			fuSetInt(s_trFilter,  IDE_IMP_PARTIALR2, i);// Hong 8/31/06 GET_FILTER_BY_ID
			
			///---Sim 04-12-2007 REORGANIZE_PARTIAL_RANGE_IMPORT
			int iSkipRows = atoi(m_ebSkipDataRows.Text);
			if( iSkipRows < 0 )
				iSkipRows = 0;
			int iReadRows = atoi(m_ebReadRows.Text);
			if( iReadRows < 1 )
				iReadRows = 1;

			fuSetInt(s_trFilter, IDE_IMP_SKIPROWS, iSkipRows);
			fuSetInt(s_trFilter, IDE_IMP_READROWS, iReadRows);
			///---END REORGANIZE_PARTIAL_RANGE_IMPORT
		}
		else
		{
			/// Hong 8/31/06 GET_FILTER_BY_ID
			//s_trFilter.Common.Partial.nVal = 0;
			//s_trFilter.Common.PartialC1.nVal = 0; // first column
			//s_trFilter.Common.PartialC2.nVal = -1; // last column
			//s_trFilter.Common.PartialR1.nVal = 0; // first row
			//s_trFilter.Common.PartialR2.nVal = -1; // last row
			fuSetInt(s_trFilter,  IDE_IMP_PARTIAL, 0);
			fuSetInt(s_trFilter,  IDE_IMP_PARTIALC1, 0);
			fuSetInt(s_trFilter,  IDE_IMP_PARTIALC2, -1);
			fuSetInt(s_trFilter,  IDE_IMP_PARTIALR1, 0);
			fuSetInt(s_trFilter,  IDE_IMP_PARTIALR2, -1);
			/// end GET_FILTER_BY_ID
			///---Sim 04-12-2007 REORGANIZE_PARTIAL_RANGE_IMPORT
			fuSetInt(s_trFilter, IDE_IMP_SKIPROWS, 0);
			fuSetInt(s_trFilter, IDE_IMP_READROWS, 1);
			///---END REORGANIZE_PARTIAL_RANGE_IMPORT
		}

		//int iImportMode = cbImportMode.GetCurSel();
		/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES
		/*
		int iImportMode = m_cbImportMode.GetCurSel();
		//int iNonNumeric = cbNonNumeric.GetCurSel();
		int iNonNumeric = m_cbNonNumeric.GetCurSel();
		DataSel_ConvertDialogToStruct(iNonNumeric, iImportMode);
		fuSetImportMode(s_trFilter, iImportMode);
		m_pAscimp->iNonnumeric = iNonNumeric;
		*/
		m_pAscimp->iNonnumeric = m_cbNonNumeric.GetCurSel();
		/// end NEW_IMPORT_MODES

		/// EJP 07-23-2003 v7.0631 QA70-4575 ADD_SKIPROWS_TO_BINIMP
		///s_ascimp.iSkipRows = atoi(ebSkipDataRows.Text);
		/// end ADD_SKIPROWS_TO_BINIMP
	}
	else // data to dialog
	{
		/// Hong 8/31/06 GET_FILTER_BY_ID
		/*
		//chkPartial.Check = s_trFilter.Common.Partial.nVal;
		m_chkPartial.Check = s_trFilter.Common.Partial.nVal;
		//editFirstCol.Text.Format("%d", s_trFilter.Common.PartialC1.nVal + 1);
		m_editFirstCol.Text.Format("%d", s_trFilter.Common.PartialC1.nVal + 1);
		//editLastCol.Text.Format("%d", s_trFilter.Common.PartialC2.nVal + 1);
		m_editLastCol.Text.Format("%d", s_trFilter.Common.PartialC2.nVal + 1);
		//editFirstRow.Text.Format("%d", s_trFilter.Common.PartialR1.nVal + 1);
		m_editFirstRow.Text.Format("%d", s_trFilter.Common.PartialR1.nVal + 1);
		//editLastRow.Text.Format("%d", s_trFilter.Common.PartialR2.nVal + 1);
		m_editLastRow.Text.Format("%d", s_trFilter.Common.PartialR2.nVal + 1);
		*/
		int nPartial, nPartialC1, nPartialC2, nPartialR1, nPartialR2;
		nPartial = fuGetInt(s_trFilter,  IDE_IMP_PARTIAL, 0);
		nPartialC1 = fuGetInt(s_trFilter,  IDE_IMP_PARTIALC1, 0);
		nPartialC2 = fuGetInt(s_trFilter,  IDE_IMP_PARTIALC2, -1);
		nPartialR1 = fuGetInt(s_trFilter,  IDE_IMP_PARTIALR1, 0);
		nPartialR2 = fuGetInt(s_trFilter,  IDE_IMP_PARTIALR2, -1);
		m_chkPartial.Check = nPartial;
		m_editFirstCol.Text.Format("%d", nPartialC1 + 1);
		m_editLastCol.Text.Format("%d", nPartialC2 + 1);
		m_editFirstRow.Text.Format("%d", nPartialR1 + 1);
		m_editLastRow.Text.Format("%d", nPartialR2 + 1);
		/// end GET_FILTER_BY_ID

		/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES
		/*
		int iImportMode = fuGetImportMode(s_trFilter);
		int iNonNumeric = m_pAscimp->iNonnumeric;
		DataSel_ConvertStructToDialog(iNonNumeric, iImportMode);
		
		//cbNonNumeric.SetCurSel(iNonNumeric);
		m_cbNonNumeric.SetCurSel(iNonNumeric);
		//cbImportMode.SetCurSel(iImportMode);
		m_cbImportMode.SetCurSel(iImportMode);
		*/
		m_cbNonNumeric.SetCurSel(m_pAscimp->iNonnumeric);
		/// end NEW_IMPORT_MODES
		
		DataSel_UpdateNonNumericCtrls();

		/// EJP 08-27-2003 v7.5677 QA70-5073 ADD_READROWS
		///	/// EJP 07-23-2003 v7.0631 QA70-4575 ADD_SKIPROWS_TO_BINIMP
		///	///ebSkipDataRows.Text.Format("%d", s_ascimp.iSkipRows);
		///	ebSkipDataRows.Text.Format("%d", tree_node_get_int(s_trFilter.Common.SkipRows, 0));
		///	/// end ADD_SKIPROWS_TO_BINIMP
		//int iSkipRows = tree_node_get_int(s_trFilter.Common.SkipRows, 0);
		int iSkipRows = fuGetInt(s_trFilter, IDE_IMP_SKIPROWS, 0);// Hong 8/31/06 GET_FILTER_BY_ID
		
		//ebSkipDataRows.Text.Format("%d", iSkipRows);
		m_ebSkipDataRows.Text.Format("%d", iSkipRows);
		//ebReadRows.Text.Format("%d", tree_node_get_int(s_trFilter.Common.ReadRows, 1));
		//m_ebReadRows.Text.Format("%d", tree_node_get_int(s_trFilter.Common.ReadRows, 1));
		m_ebReadRows.Text.Format("%d", fuGetInt(s_trFilter, IDE_IMP_READROWS, 1));// Hong 8/31/06 GET_FILTER_BY_ID
		//ebReadRows.Enable = (iSkipRows > 0);
		m_ebReadRows.Enable = (iSkipRows > 0);
		/// end ADD_READROWS
	}
}
